﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface ISpoolerPriorityStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class SpoolerPriorityDefaultStrategy : ICorrespondenceOS, ISpoolerPriorityStrategy
    {
        public SpoolerPriorityDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                          
#if DEBUG
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "SpoolerPriority";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Print");

            registryKey.SetValue(RegName,num,RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Print");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Print", "SpoolerPriority",
                                  registryKey.GetValue(RegName, 0x40), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class SpoolerPriorityController
    {
        public SpoolerPriorityController(SpoolerPriority spoolerPriority,
                                                         ISpoolerPriorityStrategy strategy)
        {
            SpoolerPriority = spoolerPriority;
            Strategy = strategy;
        }

        public SpoolerPriority SpoolerPriority { get; set; }
        public ISpoolerPriorityStrategy Strategy { get; set; }

        public void Read()
        {
            SpoolerPriority.SetSpoolerPriorityValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(SpoolerPriority.GetSpoolerPriorityValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
